% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_corncob.R
\name{DA_corncob}
\alias{DA_corncob}
\title{DA_corncob}
\usage{
DA_corncob(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  formula,
  phi.formula,
  formula_null,
  phi.formula_null,
  test,
  boot = FALSE,
  coefficient = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{formula}{an object of class \code{formula} without the response: a
symbolic description of the model to be fitted to the abundance.}

\item{phi.formula}{an object of class \code{formula} without the response: a
symbolic description of the model to be fitted to the dispersion.}

\item{formula_null}{Formula for mean under null, without response}

\item{phi.formula_null}{Formula for overdispersion under null, without response}

\item{test}{Character. Hypothesis testing procedure to use. One of
\code{"Wald"} or \code{"LRT"} (likelihood ratio test).}

\item{boot}{Boolean. Defaults to \code{FALSE}. Indicator of whether or not to
use parametric bootstrap algorithm. (See \code{\link[corncob]{pbWald}} and
\code{\link[corncob]{pbLRT}}).}

\item{coefficient}{The coefficient of interest as a single word formed by the
variable name and the non reference level. (e.g.: 'ConditionDisease' if the
reference level for the variable 'Condition' is 'control').}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`, the matrix
of summary statistics for each tag `statInfo`, and a suggested `name` of the
final object considering the parameters passed to the function.
}
\description{
Fast run for corncob differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
                         
# Differential abundance
DA_corncob(object = ps, formula = ~ group, phi.formula = ~ group,
    formula_null = ~ 1, phi.formula_null = ~ group, coefficient = "groupB",
    test = "Wald")
}
\seealso{
\code{\link[corncob]{bbdml}} and
\code{\link[corncob]{differentialTest}} for differential abundance and
differential variance evaluation.
}
