% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF.R
\name{fitModels}
\alias{fitModels}
\title{fitModels}
\usage{
fitModels(
  object,
  assay_name = "counts",
  models = c("NB", "ZINB", "DM", "ZIG", "HURDLE"),
  scale_HURDLE = c("default", "median"),
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq object, a TreeSummarizedExperiment object, or a 
matrix of counts.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{models}{character vector which assumes the values \code{NB},
\code{ZINB}, \code{DM}, \code{ZIG}, and \code{HURDLE}.}

\item{scale_HURDLE}{character vector, either \code{median} or \code{default}
to choose between the median of the library size or one million to scale raw
counts for the truncated gaussian hurdle model.}

\item{verbose}{an optional logical value. If \code{TRUE} information on the
steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
list of \code{data.frame} objects for each model. The first two
columns contain the properly transformed observed values for mean and zero
proportion, while the third and the fourth columns contain the estimated
values for the mean and the zero rate respectively.
}
\description{
A wrapper function that fits the specified models for each taxon of the count
data and computes the mean difference (MD) and zero probability difference
(ZPD) between estimated and observed values.
}
\examples{
# Generate some random counts
counts <- matrix(rnbinom(n = 600, size = 3, prob = 0.5), 
                 nrow = 100, ncol = 6)
# Estimate the counts assuming several distributions
GOF <- fitModels(
    object = counts, models = c(
        "NB", "ZINB",
        "DM", "ZIG", "HURDLE"
    ), scale_HURDLE = c("median", "default")
)

head(GOF)
}
\seealso{
\code{\link{fitNB}}, \code{\link{fitZINB}}, \code{\link{fitDM}},
\code{\link{fitZIG}}, and \code{\link{fitHURDLE}} for the model estimations,
\code{\link{prepareObserved}} for raw counts preparation, and
\code{\link{meanDifferences}} for the Mean Difference (MD) and Zero
Probability Difference (ZPD) computations.
}
