% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNormalizations.R
\name{setNormalizations}
\alias{setNormalizations}
\title{setNormalizations}
\usage{
setNormalizations(
  fun = c("norm_edgeR", "norm_DESeq2", "norm_CSS"),
  method = c("TMM", "poscounts", "CSS")
)
}
\arguments{
\item{fun}{a character with the name of normalization function (e.g.
"norm_edgeR", "norm_DESeq2", "norm_CSS"...).}

\item{method}{a character with the normalization method (e.g.
"TMM", "upperquartile"... if the \code{fun} is "norm_edgeR").}
}
\value{
a list object containing the normalization methods and their
parameters.
}
\description{
Set the methods and parameters to compute normalization/scaling factors.
}
\examples{
# Set a TMM normalization
my_TMM_normalization <- setNormalizations(fun = "norm_edgeR", method = "TMM")

# Set some simple normalizations
my_normalizations <- setNormalizations()

# Add a custom normalization
my_normalizations <- c(my_normalizations,
    myNormMethod1 = list("myNormMethod", "parameter1", "parameter2"))
}
\seealso{
\code{\link{runNormalizations}}, \code{\link{norm_edgeR}},
\code{\link{norm_DESeq2}}, \code{\link{norm_CSS}}, \code{\link{norm_TSS}}
}
