% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_ZicoSeq.R
\name{set_ZicoSeq}
\alias{set_ZicoSeq}
\title{set_ZicoSeq}
\usage{
set_ZicoSeq(
  assay_name = "counts",
  contrast = NULL,
  strata = NULL,
  adj.name = NULL,
  feature.dat.type = c("count", "proportion", "other"),
  is.winsor = TRUE,
  outlier.pct = 0.03,
  winsor.end = c("top", "bottom", "both"),
  is.post.sample = TRUE,
  post.sample.no = 25,
  perm.no = 99,
  link.func = list(function(x) sign(x) * (abs(x))^0.5),
  ref.pct = 0.5,
  stage.no = 6,
  excl.pct = 0.2,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{strata}{a factor such as subject IDs indicating the permutation strata or characters indicating the strata variable in \code{meta.dat}. Permutation will be confined to each stratum. This can be used for paired or some longitudinal designs.}

\item{adj.name}{the name(s) for the variable(s) to be adjusted. Multiple variables are allowed.
       They could be numeric or categorical; should be in \code{meta.dat}.}

\item{feature.dat.type}{the type of the feature data. It could be "count", "proportion" or "other". For "proportion" data type, posterior sampling will not be performed,
but the reference-based ratio approach will still be used to address compositional effects. For "other" data type, neither posterior sampling or reference-base ratio approach
will be used.}

\item{is.winsor}{a logical value indicating whether winsorization should be performed to replace outliers. The default is TRUE.}

\item{outlier.pct}{the expected percentage of outliers. These outliers will be winsorized. The default is 0.03. For count/proportion data, 
\code{outlier.pct} should be less than \code{prev.filter}.}

\item{winsor.end}{a character indicating whether the outliers at the "top", "bottom" or "both" will be winsorized.
The default is "top". If the \code{feature.dat.type} is "other", "both" may be considered.}

\item{is.post.sample}{a logical value indicating whether to perform posterior sampling of the underlying proportions.
 Only relevant when the feature data are counts.}

\item{post.sample.no}{the number of posterior samples if posterior sampling is used. The default is 25.}

\item{perm.no}{the number of permutations. If the raw p values are of the major interest, set \code{perm.no} to at least 999.}

\item{link.func}{a list of transformation functions for the feature data or the ratios. Based on our experience, 
square-root transformation is a robust choice for many datasets.}

\item{ref.pct}{percentage of reference taxa. The default is 0.5.}

\item{stage.no}{the number of stages if multiple-stage normalization is used. The default is 6.}

\item{excl.pct}{the maximum percentage of significant features (nominal p-value < 0.05) in the reference set that should be removed. 
Only relevant when multiple-stage normalization is used.}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_ZicoSeq}
method.
}
\description{
Set the parameters for ZicoSeq differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for ZicoSeq
base_ZicoSeq <- set_ZicoSeq(contrast = c("group", "B", "A"), 
    feature.dat.type = "count", winsor.end = "top")
many_ZicoSeq <- set_ZicoSeq(contrast = c("group", "B", "A"), 
    feature.dat.type = "count", outlier.pct = c(0.03, 0.05),
    winsor.end = "top", is.post.sample = c(TRUE, FALSE))
}
\seealso{
\code{\link{DA_ZicoSeq}}
}
