% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{modality}
\alias{modality}
\alias{modality,musica-method}
\alias{modality,result_collection-method}
\alias{modality,result_model-method}
\alias{modality<-}
\alias{modality<-,musica,matrix-method}
\alias{modality<-,result_collection,matrix-method}
\alias{modality<-,result_model,matrix-method}
\title{Retrieve modality from a result_model, result_collection, or musica
object}
\usage{
modality(x, ...)

\S4method{modality}{musica}(x, result, modality, model_id)

\S4method{modality}{result_collection}(x, modality, model_id)

\S4method{modality}{result_model}(x)

modality(x, ...) <- value

\S4method{modality}{musica,matrix}(x, result, modality, model_id) <- value

\S4method{modality}{result_collection,matrix}(x, modality, model_id) <- value

\S4method{modality}{result_model,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs
\code{\linkS4class{result_collection}} object.}

\item{result}{Name of result from result_list to assign the
modality. Used when \code{result} is a \code{\linkS4class{musica}} object.}

\item{modality}{Modality to assign the modality. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the modality. Used when
\code{result} is a \code{\linkS4class{musica}} or}

\item{value}{A modality}
}
\value{
The modality for the model
}
\description{
The modality
}
\examples{
data(res)
modality(res, "result", "SBS96", "res")
}
